clear all;close all;clc;

load pets_weights_100_150.mat

W=W_spatial+0.5*W_hist-100*W_exclude;

W=min(W,W');

D=diag(sum(abs(W),2));
L=D-W;

D1=diag(1./sqrt(sum(abs(W),2)));
L=D-W;
L_sym=D1'*L*D1;

% figure,plot3(detection_segment(:,1),detection_segment(:,2),detection_segment(:,3),'o');
% figure,plot(detection_segment(:,1),detection_segment(:,2),'o');
MARKERSIZE=5;

figure,
subplot(2,2,1);
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');
title('Input detections','fontsize',12,'fontweight','b');
set(gca,'fontsize',12);
% tightfig(h);
% print(h,'-dpng','~/Desktop/input_detections.png');



%spatio-temporal graph
subplot(2,2,2);
% h=figure;
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');
hold on;
W=W_spatial;
[r,c]=find(W>1e-1);
for ii=1:length(r)
    i=r(ii);
    j=c(ii);
    plot([detection_segment(i,1) detection_segment(j,1)],[detection_segment(i,2) detection_segment(j,2)],'r-','linewidth',5*W(i,j));
end
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');

title('Spatio-temporal graph','fontsize',12,'fontweight','b');
set(gca,'fontsize',12);
% tightfig(h);
% print(h,'-dpng','~/Desktop/spatio_temporal_graph.png');

%appearance graph
subplot(2,2,3);
% h=figure;
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');
hold on;
W=W_hist;
[r,c]=find(W>1e-1);
for ii=1:length(r)
    i=r(ii);
    j=c(ii);
    plot([detection_segment(i,1) detection_segment(j,1)],[detection_segment(i,2) detection_segment(j,2)],'r-','linewidth',5*W(i,j));
end
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');

title('Appearance graph','fontsize',12,'fontweight','b');
set(gca,'fontsize',12);
% tightfig(h);
% print(h,'-dpng','~/Desktop/appearance_graph.png');


%exclusion graph
subplot(2,2,4);
% h=figure;
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');
hold on;
W=W_exclude;
[r,c]=find(W>1e-2);
for ii=1:length(r)
    i=r(ii);
    j=c(ii);
    plot([detection_segment(i,1) detection_segment(j,1)],[detection_segment(i,2) detection_segment(j,2)],'r-','linewidth',5*W(i,j));
end
plot(detection_segment(:,1),detection_segment(:,2),'o','markersize',MARKERSIZE);%,'markerfacecolor','b');

title('Exclusion graph','fontsize',12,'fontweight','b');
set(gca,'fontsize',12);


fprintf('paused...press any key to continue\n');
pause;

for k=7:10%2:10%:5

    [Y,LAMBDA]=eigs(L_sym,k,'sm');
    Z=D1*Y;

    Zk=Z(:,[1:k]);
    
    %normalize
    Z_norm=diag(1./sqrt(diag(Zk*Zk')))*Zk;
    
    % initial solution
    n=size(Z_norm,1);
    R=eye(k);

    for iter=1:100
        %compute X
        [~,idx]=max(Z_norm*R,[],2);

        X=zeros(n,k);
        for i=1:n
            X(i,idx(i))=1;
        end

        %compute R
        ZtX=Z_norm'*X;
        [U,S,V]=svd(ZtX);

        R1=U*V';

        norm_err=norm(R-R1,'fro');

        if norm_err<1e-4
            fprintf('broken in %d iterations...norm err:%0.4f\n',iter,norm_err);
            break;
        else
            R=R1;
        end
    end
    %%
    [~,idx]=max(Z_norm*R,[],2);
    colors=distinguishable_colors(k);
    figure, hold on;
    unique_id=unique(idx);
    for ii=1:length(unique_id)
        index=find(idx==unique_id(ii));
        clr=colors(ii,:);
        plot3(detection_segment(index,1),detection_segment(index,2),detection_segment(index,3),'-o','color',clr,'markerfacecolor',clr);
    end
    title(sprintf('%d partitions',k));
    axis square;
end