clear all;close all;clc;
addpath('../useful_matlab_functions/');
addpath(genpath('~/Dropbox/cell'));
%% samples
im=imresize(imread('cameraman.tif'),[64 64]);
W=image_to_graph(double(im),10);
%% compute eigen solution of L_sym

D=diag(sum(W,2));

D1=diag(1./sqrt(sum(W,2)));
L=D-W;
L_sym=D1'*L*D1;
[Y,LAMBDA]=eigs(L_sym+1e-4*eye(size(L,1)),10,'sm');




Z=D1*Y;

%% compute and display k partitions
for k=2:5

    Zk=Z(:,[1:k]);
%     figure(100);
%     plot(Zk(:,1), Zk(:,2),'.');
%     hold on;
    %normalize
    Z_norm=diag(1./sqrt(diag(Zk*Zk')))*Zk;
    scale_factor=1/10;
%     figure(100);plot(Z_norm(:,1)*scale_factor, Z_norm(:,2)*scale_factor,'r.');
%     axis([-1 1 -1 1]*scale_factor);


    % initial solution
    n=size(Z_norm,1);
    R=eye(k);

    for iter=1:100
        %compute X
        [~,idx]=max(Z_norm*R,[],2);
        
%         figure(100);
%         plot(Z_norm(:,1)*scale_factor, Z_norm(:,2)*scale_factor,'r+');
%         
        X=zeros(n,k);
        for i=1:n
            X(i,idx(i))=1;
        end

        %compute R
        ZtX=Z_norm'*X;
        [U,S,V]=svd(ZtX);

        R1=U*V';

        norm_err=norm(R-R1,'fro');

        if norm_err<1e-4
            fprintf('broken in %d iterations...norm err:%0.4f\n',iter,norm_err);
            break;
        else
            R=R1;
        end
    end

    colors=distinguishable_colors(k);
    figure, hold on;
    unique_id=unique(idx);
    for ii=1:length(unique_id)
        index=find(idx==unique_id(ii));
        clr=colors(ii,:);
        plot(xy(index,1),xy(index,2),'o','color',clr,'markerfacecolor',clr);
    end
    title(sprintf('%d partitions',k));
    axis square;
end
