clear all;close all;clc;
addpath('../useful_matlab_functions/');
%% samples
load xy.mat
figure,plot(xy(:,1),xy(:,2),'o','markerfacecolor','b');hold on;
title('sample points');
axis square;
%% compute affinity between the points
SIGMA=20;
dd=squareform(pdist(xy));
W=exp(-dd.^2/SIGMA^2);

W=W-diag(diag(W));

[x,y]=ginput(1);
dd=bsxfun(@minus,xy,[x y]);
index1=find(sum(dd.*dd,2)<5);
if length(index1)>1
    index1=index1(1);
end
plot(xy(index1,1),xy(index1,2),'ro','markerfacecolor','r');


[x,y]=ginput(1);
dd=bsxfun(@minus,xy,[x y]);
index2=find(sum(dd.*dd,2)<5);
if length(index2)>1
    index2=index2(1);
end

plot(xy(index2,1),xy(index2,2),'ro','markerfacecolor','r');

W(index1,index2)=-100;
W(index2,index1)=-100;

%% compute eigen solution of L_sym

D=diag(sum(abs(W),2));

D1=diag(1./sqrt(sum(abs(W),2)));
L=D-W;
L_sym=D1'*L*D1;
[Y,LAMBDA]=eigs(L_sym,10,'sm');




Z=D1*Y;

%% compute and display k partitions
for k=2:3%:5

    Zk=Z(:,[1:k]);
    figure(100);
    plot(Zk(:,1), Zk(:,2),'.');
    hold on;
    %normalize
    Z_norm=diag(1./sqrt(diag(Zk*Zk')))*Zk;
    scale_factor=1/10;
    figure(100);plot(Z_norm(:,1)*scale_factor, Z_norm(:,2)*scale_factor,'r.');
    axis([-1 1 -1 1]*scale_factor);


    % initial solution
    n=size(Z_norm,1);
    R=eye(k);

    for iter=1:100
        %compute X
        [~,idx]=max(Z_norm*R,[],2);
        
%         figure(100);
%         plot(Z_norm(:,1)*scale_factor, Z_norm(:,2)*scale_factor,'r+');
%         
        X=zeros(n,k);
        for i=1:n
            X(i,idx(i))=1;
        end

        %compute R
        ZtX=Z_norm'*X;
        [U,S,V]=svd(ZtX);

        R1=U*V';

        norm_err=norm(R-R1,'fro');

        if norm_err<1e-4
            fprintf('broken in %d iterations...norm err:%0.4f\n',iter,norm_err);
            break;
        else
            R=R1;
        end
    end

    colors=distinguishable_colors(k);
    figure, hold on;
    unique_id=unique(idx);
    for ii=1:length(unique_id)
        index=find(idx==unique_id(ii));
        clr=colors(ii,:);
        plot(xy(index,1),xy(index,2),'o','color',clr,'markerfacecolor',clr);
    end
    title(sprintf('%d partitions',k));
    axis square;
end
