function op = opGrad_AG(n)
% OPGRAD_AG  Gradient operator
%
%    OPWAVELET_AG(N)
%    creates a gradient operator and its transpose given by -div.
%    This operator is applied to vectors of length N
%
% Copyright 2015 Adriana Gonzalez
% PhD Student at Universite catholique de Louvain (UCL), Belgium

op = @(x,mode) opGrad_AG_intrnl(n,x,mode);

function y = opGrad_AG_intrnl(n,x,mode)

checkDimensions(2*n*n,n^2,x,mode);

if (mode == 0)
    y = {2*n*n,n^2,[0,1,0,1],{'Gradient: Finite Differences'}};
elseif (mode == 1)
    aux = reshape(x,n,n);
    y = [reshape([diff(aux,1,2) zeros(n,1)],n*n,1); reshape([diff(aux,1,1); zeros(1,n)],n*n,1)];
else
    aux = [reshape(x(1:n*n),n,n); reshape(x(n*n+1:end),n,n)];
    y = -reshape(diff([zeros(n,1) aux(1:n,:)],1,2) + diff([zeros(1,n); aux(n+1:2*n,:)],1,1),n^2,1);
end