function [noisevar,filtered_signal] = median_estimator(n,x,Wn)
% Robust median estimator. Method for calculating the variance of a signal
% 'x' of length 'n' that is assumed to be AWGN with mean 0 and variance
% sigma^2 = noisevar. The method is based on the assumption that the noise is an
% additional high frequency component in the observed signal. This
% component is filtered using a high frequency with a normalized cut-off
% frequency 'Wn'.
%
% Reference:
% [1] D. Donoho and I. Johnstone. Ideal spatial adaptation by wavelet
% shrinkage. Biometrika, 81(3), 425-455, 1994
%
% Copyright 2011 Adriana Gonzalez
% PhD Student at Universite catholique de Louvain (UCL), Belgium

win = chebwin(n);   % Chebyshev window of length n
h = fir1((n-1),Wn,'high',win);  % 1-D filter
filtered_signal = conv(h,x);    
noisevar = median(abs(filtered_signal))/0.6745*norm(h); % estimated sigma^2