function xb = bisect(f,a,b,tol,show)
% Matlab function bisect.m
% Solves f(x) = 0 using the bisection method
%
% Inputs:
% a = left endpoint of interval
% b = right endpoint of interval
% tol = tolerance for stopping bisection method
%
% Required m-file:
% f.m is m-file for function f(x)
%
% Outputs:
% Root by bisection


it = 0; % set iteration count to zero
fa = f(a);
fb = f(b);

% check bracketing

if sign(fa)==sign(fb); 
    error('Root not in bracket'); 
end

% begin while loop

while (b-a)>tol
    
    it = it + 1;
    c = a + 0.5*(b-a);
    fc = f(c);
    if sign(fa)~=sign(fc);
        % root lies in [a,c]
        b = c;
        fb = fc;
    else
        % root lies in [c,b]
        a = c;
        fa = fc;
    end
    
    
    xb = 0.5*(a + b);
    err = 0.5*abs(b - a);
    if show % print progress
        fprintf('\n n = %i Solution = %15.10e error = %15.10e\n',it,xb, err);
    end
%     pause;
    % The pause command causes the execution of this routine to
    % be paused at the end of each iteration. Press any key
    % on the keyboard to continue.
    
end

if show % print results
    format long e
    fprintf('\n\n Computed Solution = %e \n\n',xb);
    fprintf('Iteration count = %i\n\n',it);
end
