function y = Proj_l1ball(x,epsilon)
% y = Proj_l1ball(x,epsilon)
% 
% This function computes the projection onto the l1-norm ball of radius
% epsilon, a set described as C = { x | ||x||_1 <= epsilon }. 
% The projection is defined by Boyd [1] as:
%
%       y = P_C(x) = SoftTh(x,lambda)
%
%       (P_C(x))_i  = { x_i - lambda    if x_i > lambda
%                           0           if -lambda <= x_i <= lambda       
%                       x_i + lambda    if x_i < -lambda }
%
% with lambda = 0 if ||x||_1 <= epsilon, otherwise lambda is given by the
% solution of the following equation (computed using the bisection method):
%       sum_{i=1}^{length(x)} max {0, |x_i| - lambda} = epsilon
%
% References:
% [1] Boyd. EE236C (Spring 2011-12). The proximal mapping. Slide 8-19
% [2] Parikh and Boyd. Proximal Algorithms. Foundations and Trends in
% Optimization 1(3), pp. 123-231, 2013.
%
% Copyright 2015 Adriana Gonzalez 
% PhD Student at Universite catholique de Louvain (UCL), Belgium

show = 0;
N = length(x);
f = @(lambda) sum(max(zeros(N,1),abs(x)-lambda*ones(N,1))) - epsilon;

% Initial value for bisection method
a = max(x)-1; b = max(x);

while sign(f(a))==sign(f(b))
    a = a-1;
    b = b+1;
end

lambda = (norm(x,1)>epsilon)*bisect(f,a,b,1e-5,show);

y = SoftTh(x,lambda);